#include <iostream>
#include <vector>
#include <queue>

using namespace std;

const int MAXN = 500005;

int N;
vector<int> graph[MAXN];
vector<int> hasPlatform(MAXN, 0);
vector<int> changeRoom(MAXN, 0);
vector<int> minJumps(MAXN, -1);

void bfs() {
    queue<pair<int, int>> q;
    q.push({1, 0}); // Node and minimum jumps to reach it

    while (!q.empty()) {
        int node = q.front().first;
        int prevJump = q.front().second;
        q.pop();

        if (minJumps[node] != -1) {
            continue;
        }

        int currJumps = prevJump + 1;

        if (hasPlatform[node] == 1) {
            currJumps = 1;
        }

        if (changeRoom[node] != 0) {
            bool hasValidPlatform = false;
            for (int prevNode : graph[node]) {
                if (hasPlatform[prevNode] == 1 && changeRoom[node] == prevNode) {
                    hasValidPlatform = true;
                    break;
                }
            }

            if (!hasValidPlatform) {
                currJumps = 1;
            }
        }

        minJumps[node] = currJumps;

        for (int nextNode : graph[node]) {
            q.push({nextNode, currJumps});
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    cin >> N;

    for (int i = 1; i < N; i++) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    for (int i = 1; i <= N; i++) {
        cin >> hasPlatform[i];
    }

    for (int i = 1; i <= N; i++) {
        cin >> changeRoom[i];
    }

    bfs();

    for (int i = 1; i <= N; i++) {
        cout << minJumps[i] << " ";
    }

    return 0;
}